/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.trendmonitoring.reference
{

    using org.owasp.appsensor.trendmonitoring;

    /**
     * This very simple implementation of the TrendLogger interface 
     * simply logs events to the in-memory data store for storage.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since June 17, 2010
     */
    public class InMemoryTrendLogger : TrendLogger
    {
        private static volatile TrendLogger singletonInstance;

        public static TrendLogger GetInstance()
        {
            if (singletonInstance == null)
            {
                lock (typeof(InMemoryTrendLogger))
                {
                    if (singletonInstance == null)
                    {
                        singletonInstance = new InMemoryTrendLogger();
                    }
                }
            }
            return singletonInstance;
        }

        public void Log(TrendEvent e)
        {
            InMemoryTrendDataStore.GetInstance().AddEvent(e);
        }
    }
}